USE [BMS]
GO

/****** Object:  StoredProcedure [dbo].[usp_Get_WaitingListItem]    Script Date: 4/13/2016 3:43:59 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Author:		PII
-- Create date: 30.08.2011
-- Description:	Get waiting list item by ID.
-- =============================================
ALTER PROCEDURE [dbo].[usp_Get_WaitingListItem] 
	@ACT_ID	INT = NULL,
	@DOMAIN_ID NVARCHAR(50) = NULL,
	@PATIENT_UID UNIQUEIDENTIFIER = NULL
AS
BEGIN
SET NOCOUNT ON

	DECLARE @SQL_SELECT NVARCHAR(max), @SQL_WHERE NVARCHAR(4000), @SQL NVARCHAR(max)

	SET @SQL_SELECT = 'SELECT
						[A].[ID] AS ACT_ID,
						[A].[CREATION_DATE],
						[A].[CANCELED_DATE],
						[A].[PARENT_ACT_ID],
						[A].[FLOW_ID],
						[A].[DOMAIN_ID],
						[A].[IEN],
						[A].[PATIENT_UID] AS [PATIENT_UID],
						[WL].[FACILITY_UID] AS [FACILITY_UID],
						[WA].[CODE] AS [WAITING_AREA_CODE],
						[WA].[CODE_SYSTEM] AS [WAITING_AREA_CODE_SYSTEM],
						[WA].[CODE_SYSTEM_NAME] AS [WAITING_AREA_CODE_SYSTEM_NAME],
						[WA].[DISPLAY_NAME] AS [WAITING_AREA_DISPLAY_NAME],										
						[WL].[PROBLEM] AS [PROBLEM],
						[FD].[CODE] AS [FEE_DISPOSITION_CODE],
						[FD].[CODE_SYSTEM] AS [FEE_DISPOSITION_CODE_SYSTEM],
						[FD].[CODE_SYSTEM_NAME] AS [FEE_DISPOSITION_CODE_SYSTEM_NAME],
						[FD].[DISPLAY_NAME] AS [FEE_DISPOSITION_DISPLAY_NAME],
						[CF].[CODE] AS [CONTRACT_FEE_CODE],
						[CF].[CODE_SYSTEM] AS [CONTRACT_FEE_CODE_SYSTEM],
						[CF].[CODE_SYSTEM_NAME] AS [CONTRACT_FEE_CODE_SYSTEM_NAME],
						[CF].[DISPLAY_NAME] AS [CONTRACT_FEE_DISPLAY_NAME],
						[AF].[CODE] AS [AUTHORIZED_FEE_CODE],
						[AF].[CODE_SYSTEM] AS [AUTHORIZED_FEE_CODE_SYSTEM],
						[AF].[CODE_SYSTEM_NAME] AS [AUTHORIZED_FEE_CODE_SYSTEM_NAME],
						[AF].[DISPLAY_NAME] AS [AUTHORIZED_FEE_DISPLAY_NAME],
						[SRF].[CODE] AS [SERVICE_RECEIVING_FEE_CODE],
						[SRF].[CODE_SYSTEM] AS [SERVICE_RECEIVING_FEE_CODE_SYSTEM],
						[SRF].[CODE_SYSTEM_NAME] AS [SERVICE_RECEIVING_FEE_CODE_SYSTEM_NAME],
						[SRF].[DISPLAY_NAME] AS [SERVICE_RECEIVING_FEE_DISPLAY_NAME],
						[RUF].[CODE] AS [REASON_USING_FEE_CODE],
						[RUF].[CODE_SYSTEM] AS [REASON_USING_FEE_CODE_SYSTEM],
						[RUF].[CODE_SYSTEM_NAME] AS [REASON_USING_FEE_CODE_SYSTEM_NAME],
						[RUF].[DISPLAY_NAME] AS [REASON_USING_FEE_DISPLAY_NAME],
						[WL].[FEE_COMMENTS] AS [FEE_COMMENTS],
						[WL].[REMOVED_DATE] AS [REMOVED_DATE],
						[WL].[TYPE_OF_BED_WARD] AS [TYPE_OF_BED_WARD],	
						[WL].[REQUESTED_BED_UID] AS [REQUESTED_BED_UID],
						[WL].[REQUESTED_BED_DATE] AS [REQUESTED_BED_DATE],
						[WL].[REQUESTED_DATE] AS [REQUESTED_DATE],
						[WL].[VISTA_SITE_UID] AS [VISTA_SITE_UID],
						[WL].[IS_IN_HOUSE] AS [IS_IN_HOUSE],
						[WL].[LAST_EDIT_BY] AS [LAST_EDIT_BY],
						[WL].[COMMENTS] AS [COMMENTS],
						[WL].[IS_BED_IN_ISOLATION] AS IS_BED_IN_ISOLATION,
						[WL].[WAIT_TIME_ALERT_DATE] AS WAIT_TIME_ALERT_DATE,
						[WL].[IS_COMMUNITY_LIVING_CENTER] AS [IS_COMMUNITY_LIVING_CENTER], 
						[WL].[IS_EVACUATION_PATIENT] AS [IS_EVACUATION_PATIENT],
						[WL].[IS_MENTAL_HEALTH_PATIENT] AS [IS_MENTAL_HEALTH_PATIENT],
						[EDS].[CODE] AS [EVACUATION_DISPOSITION_STATUS_CODE],
						[EDS].[CODE_SYSTEM] AS [EVACUATION_DISPOSITION_STATUS_CODE_SYSTEM],
						[EDS].[CODE_SYSTEM_NAME] AS [EVACUATION_DISPOSITION_STATUS_CODE_SYSTEM_NAME],
						[EDS].[DISPLAY_NAME] AS [EVACUATION_DISPOSITION_STATUS_DISPLAY_NAME],
						[WL].[EVACUATION_EXPECTED_DATE] AS [EVACUATION_EXPECTED_DATE],
						[WL].[EVACUATION_ACTUAL_DATE] AS [EVACUATION_ACTUAL_DATE],
						[WL].[EVACUATION_REASON_FOR_DELAY] AS [EVACUATION_REASON_FOR_DELAY],
						[WL].[EVACUATION_TRANSFER_EVACUATE_TO] AS [EVACUATION_TRANSFER_EVACUATE_TO],
						[WL].[EVACUATION_EQUIP_SUPPLY_REQUIREMENTS] AS [EVACUATION_EQUIP_SUPPLY_REQUIREMENTS],
						[WL].[EVACUATION_TRANSPORTATION_CARE_LEVEL] AS [EVACUATION_TRANSPORTATION_CARE_LEVEL],
						[WL].[EVACUATION_ENROUTE_MEDICAL_ATTENDANT] AS [EVACUATION_ENROUTE_MEDICAL_ATTENDANT],
						[WL].[EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT] AS [EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT],
						[ETT].[CODE] AS [EVACUATION_TRANSPORTATION_TYPE_CODE],
						[ETT].[CODE_SYSTEM] AS [EVACUATION_TRANSPORTATION_TYPE_CODE_SYSTEM],
						[ETT].[CODE_SYSTEM_NAME] AS [EVACUATION_TRANSPORTATION_TYPE_CODE_SYSTEM_NAME],
						[ETT].[DISPLAY_NAME] AS [EVACUATION_TRANSPORTATION_TYPE_DISPLAY_NAME],
						[ETP].[CODE] AS [EVACUATION_TRANSPORTATION_PROVIDER_CODE],
						[ETP].[CODE_SYSTEM] AS [EVACUATION_TRANSPORTATION_PROVIDER_CODE_SYSTEM],
						[ETP].[CODE_SYSTEM_NAME] AS [EVACUATION_TRANSPORTATION_PROVIDER_CODE_SYSTEM_NAME],
						[ETP].[DISPLAY_NAME] AS [EVACUATION_TRANSPORTATION_PROVIDER_DISPLAY_NAME],
						[WL].[EVACUATION_TRANSPORTATION_COMMENTS] AS [EVACUATION_TRANSPORTATION_COMMENTS],
						[WL].[EVACUATION_DESTINATION_ADDRESS] AS [EVACUATION_DESTINATION_ADDRESS],
						[WL].[EVACUATION_DESTINATION_CITY_STATE] AS [EVACUATION_DESTINATION_CITY_STATE],
						[WL].[EVACUATION_DESTINATION_POC_TELEPHONE] AS [EVACUATION_DESTINATION_POC_TELEPHONE],
						[WL].[EVACUATION_ORIGINATOR_POC_TELEPHONE] AS [EVACUATION_ORIGINATOR_POC_TELEPHONE],
						[WL].[EVACUATION_COMMENTS] AS [EVACUATION_COMMENTS],
						[WL].[EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER] AS EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER, 
						[WL].[EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER] AS EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER,
						[WL].[EVACUATION_ARRIVAL_TIME] AS EVACUATION_ARRIVAL_TIME,
						[WL].[EVACUATION_VEHICLE_ID] AS EVACUATION_VEHICLE_ID,
						[WL].[EVACUATION_VEHICLE_SEAT_POSITION] AS EVACUATION_VEHICLE_SEAT_POSITION,
						[WL].[EVACUATION_MA_TELEPHONE] AS EVACUATION_MA_TELEPHONE,
						[WL].[EVACUATION_NMA_TELEPHONE] AS EVACUATION_NMA_TELEPHONE,
						[WL].[EVACUATION_ORIGINATING_FACILITY_NAME] AS EVACUATION_ORIGINATING_FACILITY_NAME,
						[WL].[EVACUATION_ORIGINATING_ADDRESS] AS EVACUATION_ORIGINATING_ADDRESS,
						[WL].[EVACUATION_ORIGINATING_CITY_STATE] AS EVACUATION_ORIGINATING_CITY_STATE,
						[WL].[EVACUATION_VEHICLE_OPERATOR_NAME] AS EVACUATION_VEHICLE_OPERATOR_NAME,
						[WL].[EVACUATION_VEHICLE_OPERATOR_TELEPHONE] AS EVACUATION_VEHICLE_OPERATOR_TELEPHONE,
						[WL].[DATE_OF_SCREENING] AS DATE_OF_SCREENING,
						[WL].[CONTACT_PHONE_NUMBER] AS CONTACT_PHONE_NUMBER, 
						[WL].[VETERAN_PREFERENCE] AS VETERAN_PREFERENCE, 
						[WL].[MENTAL_HEALTH_COMMENTS] AS MENTAL_HEALTH_COMMENTS, 
						[WL].[PATIENT_FLOW_COMMENTS] AS PATIENT_FLOW_COMMENTS,
						[WL].[FEE_ACCEPTED] AS FEE_ACCEPTED, 
						[WL].[FEE_ACCEPTING_MD] AS FEE_ACCEPTING_MD
					   FROM ACT A
						INNER JOIN WAITING_LIST WL ON A.ID = WL.ACT_ID
						LEFT JOIN CONCEPT AS WA ON WL.WAITING_AREA_ID = WA.ID
						LEFT JOIN CONCEPT AS FD ON WL.FEE_DISPOSITION_ID = FD.ID
						LEFT JOIN CONCEPT AS CF ON WL.CONTRACT_FEE_ID = CF.ID
						LEFT JOIN CONCEPT AS AF ON WL.AUTHORIZED_FEE_ID = AF.ID
						LEFT JOIN CONCEPT AS SRF ON WL.SERVICE_RECEIVING_FEE_ID = SRF.ID
						LEFT JOIN CONCEPT AS RUF ON WL.REASON_USING_FEE_ID = RUF.ID
						LEFT JOIN CONCEPT AS EDS ON EDS.ID = WL.EVACUATION_DISPOSITION_STATUS_ID
						LEFT JOIN CONCEPT AS ETT ON ETT.ID = WL.EVACUATION_TRANSPORTATION_TYPE_ID
						LEFT JOIN CONCEPT AS ETP ON ETP.ID = WL.EVACUATION_TRANSPORTATION_PROVIDER_ID'
							
	SET @SQL_WHERE = ' WHERE 1=1 '
	
	IF (@ACT_ID IS NOT NULL AND @DOMAIN_ID IS NOT NULL) --@Patient_UID IS NULL
	 SET @SQL_WHERE += ' AND ([A].[ID] = ''' + CAST(@ACT_ID AS VARCHAR) + ''' AND [A].[DOMAIN_ID] = ''' + @DOMAIN_ID + ''')'
	 
	IF (@PATIENT_UID IS NOT NULL) --@ACT_ID IS NULL AND @DOMAIN_ID IS NULL 
	 SET @SQL_WHERE += ' AND ([A].[PATIENT_UID] = ''' + CAST(@PATIENT_UID AS VARCHAR(50)) + ''' AND [WL].[REMOVED_DATE] IS NULL)'
	
	SET @SQL = @SQL_SELECT + @SQL_WHERE
    
    EXECUTE sp_executesql @SQL 	
END

GO